/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.ethernet;

import ibm.nways.ethernet.model.RptrPortModel;
import ibm.nways.jdm.I18NGiblets;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.JdmServerImpl;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.modelgen.StatusMapper;
import ibm.nways.jdm.modelgen.StatusModelInfo;
import ibm.nways.jdm.modelgen.TableStatusNamer;
import java.util.Locale;

public class ActionEthernetRptrPort
implements StatusMapper,
TableStatusNamer {
    private static String bundleName = "ibm.nways.ethernet.Resources";
    private static String enumBundle = "ibm.nways.ethernet.eui.EnumeratedResources";
    private boolean loggingOn = false;

    public ActionEthernetRptrPort() {
        String string = JdmServerImpl.getProperty("startLogging");
        if (string != null && string.equals("yes")) {
            this.loggingOn = true;
        }
    }

    public void calculateStatus(StatusModelInfo statusModelInfo, StatusModelInfo statusModelInfo2) {
        try {
            Object[] objectArray = statusModelInfo.getIndexes();
            if (this.loggingOn) {
                System.out.println("ActionEthernetRptrPort");
                System.out.println("Group = " + objectArray[0] + " Port = " + objectArray[1]);
                System.out.println("rptrPortAdminStatus = " + statusModelInfo.get("Panel.RptrPortAdminStatus"));
                System.out.println("rptrPortOperStatus = " + statusModelInfo.get("Panel.RptrPortOperStatus"));
            }
            StatusAndExplain statusAndExplain = this.evaluateStatus((Integer)statusModelInfo.get("Panel.RptrPortAdminStatus"), (Integer)statusModelInfo.get("Panel.RptrPortOperStatus"), objectArray);
            statusModelInfo.setStatusType(statusAndExplain.statType, statusAndExplain.explain, true);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public I18NString nameThatObject(StatusModelInfo statusModelInfo) {
        Object[] objectArray = statusModelInfo.getIndexes();
        I18NMsgFormat i18NMsgFormat = new I18NMsgFormat(bundleName, "STATUS_NAME_RPTRPORT", objectArray);
        return i18NMsgFormat;
    }

    public I18NString nameThatTableObject(StatusModelInfo statusModelInfo) {
        I18NString i18NString = new I18NString(bundleName, "STATUS_TABLE_NAME_RPTRPORT");
        return i18NString;
    }

    private StatusAndExplain evaluateStatus(int n, int n2, Object[] objectArray) {
        StatusAndExplain statusAndExplain = new StatusAndExplain();
        Object[] objectArray2 = new Object[4];
        objectArray2[0] = objectArray[0];
        objectArray2[1] = objectArray[1];
        block2 : switch (n) {
            case 1: {
                switch (n2) {
                    case 1: 
                    case 3: {
                        statusAndExplain.statType = StatusType.NORMAL;
                        break block2;
                    }
                    case 2: {
                        statusAndExplain.statType = StatusType.CRITICAL;
                        break block2;
                    }
                }
                statusAndExplain.statType = StatusType.UNKNOWN;
                break;
            }
            case 2: {
                statusAndExplain.statType = StatusType.ADMIN_DISABLED;
                break;
            }
            default: {
                statusAndExplain.statType = StatusType.UNKNOWN;
            }
        }
        try {
            objectArray2[2] = new I18NString(enumBundle, RptrPortModel.Panel.RptrPortAdminStatusEnum.numericToSymbolic(n));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            objectArray2[2] = new I18NString(bundleName, "UNEXPECTED_RPTRPORT_ADMIN_STATUS");
        }
        try {
            objectArray2[3] = new I18NString(enumBundle, RptrPortModel.Panel.RptrPortOperStatusEnum.numericToSymbolic(n2));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            objectArray2[3] = new I18NString(bundleName, "UNEXPECTED_RPTRPORT_OPER_STATUS");
        }
        statusAndExplain.explain = new I18NGiblets(bundleName, "RPTR_PORT_STATUS_TEXT", objectArray2);
        if (this.loggingOn) {
            System.out.println("ret.statType = " + statusAndExplain.statType);
            System.out.println("ret.explain = " + statusAndExplain.explain.getTranslation(Locale.getDefault()));
        }
        return statusAndExplain;
    }

    private class StatusAndExplain {
        StatusType statType;
        I18NGiblets explain;

        StatusAndExplain() {
            ActionEthernetRptrPort.this = ActionEthernetRptrPort.this;
        }
    }
}

